###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_npl_info_disc_vuln.nasl 7117 2010-02-05 12:40:05Z feb $
#
# Microsoft Internet Explorer Information Disclosure Vulnerability (980088)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800461);
  script_version("$Revision: 6681 $:1.0");
  script_cve_id("CVE-2010-0255");
  script_bugtraq_id(38055, 38056);
  script_name("Microsoft Internet Explorer Information Disclosure Vulnerability (980088)");
  desc = "
  Overview:
  The host is installed with Internet Explorer and is prone to Information
  Disclosure vulnerability.

  Vulnerability Insight:
  The issue is caused due to the browser failing to prevent local content from
  being rendered as HTML via the 'file://' protocol, which could allow attackers
  to access files with an already known filename and location on a vulnerable
  system.

  Impact:
  Successful exploitation will allow remote attackers to gain knowledge of
  sensitive information.

  Impact Level:System/ Application

  Affected Software/OS:
  Internet Explorer Version 5.x, 6.x, 7.x , 8.x

  Fix: Apply the patch from below link,
  http://support.microsoft.com/kb/980088

  Workaround:
  Apply workaround as in the advisory.

  References:
  http://support.microsoft.com/kb/980088
  http://www.vupen.com/english/advisories/2010/0291
  http://www.microsoft.com/technet/security/advisory/980088.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");

ieVer = get_kb_item("MS/IE/Version");
if(isnull(ieVer)){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                            "\Internet Settings\RestrictedProtocols"))
{
  #Check for workaround
  value = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                          "\Internet Settings\RestrictedProtocols\1", item:"file");
  if("file" >!<  value)
  {
    #check for workaround
    pValue = registry_get_dword(key:"SOFTWARE\Microsoft\Internet Explorer\Main" +
                         "\FeatureControl\FEATURE_PROTOCOL_LOCKDOWN", item:"explorer.exe");
    if(pValue != "1" && (pValue == 0))
    {
      #Check for version
      if(ieVer =~ "^[5|6|7|8]\."){
        security_hole(0);
      }
    }
  }
}
