###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_null_ptr_dos_vuln.nasl 842 2009-01-09 11:48:24Z jan $
#
# Microsoft Internet Explorer NULL Pointer DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800337);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0072");
  script_bugtraq_id(33149);
  script_name("Microsoft Internet Explorer NULL Pointer DoS Vulnerability");
  desc = "

  Overview: This host has Internet Explorer installed and is prone to Remote
  Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper handling of onload=screen[''] attribute
  value in BODY element. By persuading a victim to visit a specially-crafted
  Web page, denial of service can be caused.

  Impact:
  Successful exploitation could allow remote attackers to cause the application
  to crash.

  Impact Level: Application

  Affected Software/OS:
  Microsoft, Internet Explorer version 6.0, 7.0, 8.0 Beta2 and prior.

  Fix: No solution or patch is available as on 09th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/products/default.aspx

  References:
  http://xforce.iss.net/xforce/xfdb/47788
  http://skypher.com/index.php/2009/01/07/msie-screen-null-ptr-dos-details/

  CVSS Score:
    CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for IE version 6.0, 7.0, 8.0 Beta2 and prior
if(version_in_range(version:ieVer, test_version:"6.0",
                    test_version2:"8.0.6001.18241")){
  security_warning(0);
}
