###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_money_dos_vuln.nasl 812 2009-01-07 13:40:24Z jan $
#
# Microsoft Money 'prtstb06.dll' Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800218);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5823");
  script_name("Microsoft Money 'prtstb06.dll' Denial of Service vulnerability");
  desc = "

  Overview: This host has Microsoft Money installed and is prone to Denial
  of Service Vulnerability.

  Vulnerability Insight:
  The flaw is due to an error in the Windows Based Script Host which lets
  the attacker execute arbitrary codes in the vulnerable buffer to crash
  the application.

  Impact:
  Successful exploitation will let the attacker to change the vulnerable
  EIP value and can cause denial of service to the application.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Money 2006 on Windows. 

  Fix: No solution or patch is available as on 08th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/MONEY/default.mspx

  References:
  http://jbrownsec.blogspot.com/2008/12/new-year-research-are-upon-us.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:N/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Microsoft Money");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_ms_money_detect.nasl");
  exit(0);
}


msmVer = get_kb_item("MS/Money/Version");
if(!msmVer){
  exit(0);
}

# Check for version Microsoft Money 2006
if(msmVer =~ "2006"){
  security_warning(0);
}
