###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_sharepoint_info_disc_vuln.nasl 5565 2009-11-04 15:47:24Z nov $
#
# Microsoft SharePoint Team Services Information Disclosure Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800968);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3830");
  script_bugtraq_id(36817);
  script_name("Microsoft SharePoint Team Services Information Disclosure Vulnerability");
  desc = "
  Overview: This host is installed with Microsoft SharePoint Server and is
  prone to Information Disclosure Vulnerability.

  Vulnerability Insight:
  This flaw is caused due to insufficient validation of user supplied data
  passed into 'SourceUrl' and 'Source' parameters in the download.aspx in
  SharePoint Team Services.

  Impact:
  Attackers can exploit this issue via specially-crafted HTTP requests to
  obtain the source code of arbitrary ASP.NET files from the backend database.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Office SharePoint Server 2007 12.0.0.6219 and prior.

  Fix:
  No solution or patch is available as on 04th November, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sharepoint.microsoft.com/Pages/Default.aspx

  References:
  http://support.microsoft.com/kb/976829
  http://xforce.iss.net/xforce/xfdb/53955
  http://www.securityfocus.com/archive/1/archive/1/507419/100/0/threaded

  Risk factor: Informational";

  script_description(desc);
  script_summary("Check for the version of MS SharePoint Team Services");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("remote-detect-WindowsSharepointServices.nasl");
  script_require_keys("MicrosoftSharePointTeamServices/version");
  exit(0);
}


include("version_func.inc");

stsVer = get_kb_item("MicrosoftSharePointTeamServices/version");
if(isnull(stsVer)){
  exit(0);
}

if(version_in_range(version:stsVer, test_version:"12.0", test_version2:"12.0.0.6219")){
  security_warning(0);
}
