###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_video_actvx_bof_vuln_jul09.nasl 3328 2009-07-08 12:27:16Z jul $
#
# Microsoft Video ActiveX Control 'msvidctl.dll' BOF Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
#  Updated to MS09-032 Bulletin (973346) #3502
#    - By Sharath S <sharaths@secpod.com> on 2009-07-15
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800829);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-0015", "CVE-2008-0020");
  script_bugtraq_id(35558);
  script_name("Microsoft Video ActiveX Control 'msvidctl.dll' BOF Vulnerability");
  desc = "

  Overview:
  This host is installed with Microsoft Video ActiveX Control and is prone to
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  - Stack-based buffer overflow error in MPEG2TuneRequest in msvidctl.dll in
    Microsoft DirectShow can be exploited via a crafted web page.
  - Unspecified error in msvidctl.dll is caused via unknown vectors that trigger
    memory corruption.

  Impact:
  Successful exploitation could allow execution of arbitrary code that affects
  the TV Tuner library, and can cause memory corruption.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Video ActiveX Control on Windows 2000/XP/2003

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-032.mspx

  Workaround:
  Set the killbit for the CLSID {0955AC62-BF2E-4CBA-A2B9-A63F772D46CF}
  http://www.microsoft.com/technet/security/advisory/972890.mspx

  References:
  http://www.iss.net/threats/329.html
  http://secunia.com/advisories/35683
  http://support.microsoft.com/kb/972890
  http://isc.sans.org/diary.html?storyid=6733

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the CLSID and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# MS09-032 Hotfix (973346)
if(hotfix_missing(name:"973346") == 0){
#  exit(0);
}

dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(dllPath == NULL){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\msvidctl.dll");
dllVer = GetVer(share:share, file:file);

if(egrep(pattern:"^6\..*", string:dllVer))
{
  # Check if Kill-Bit is set for ActiveX control
  if(is_killbit_set(clsid:"{0955AC62-BF2E-4CBA-A2B9-A63F772D46CF}") == 0){
    security_hole(0);
  }
}
