###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_myserver_remote_dos_vuln.nasl 503 2008-11-19 19:22:24Z nov $
#
# MyServer Remote Denial of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800306);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5160");
  script_bugtraq_id(27981);
  script_name("MyServer Remote Denial of Service Vulnerability");
  desc = "

  Overview: This host is running MyServer and is prone to denial of service
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to multiple invalid requests in HTTP GET, DELETE,
  OPTIONS, and possibly other methods. These requests are related to
  '204 No Content error'.

  Impact:
  Successful attacks will lead to denial of service to legitimate users.

  Impact Level: Application

  Affected Software/OS:
  MyServer MyServer version 0.8.11 and prior on all running platforms.

  Fix: No solution/patch is available as on 21st November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://www.myserverproject.net/index.php/Downloads

  References:
  http://www.milw0rm.com/exploits/5184
  http://www.securityfocus.com/bid/27981
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5160

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of MyServer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

banner = get_http_banner(port);
if(!banner){
  exit(0);
}

mysvrVer = eregmatch(pattern:"MyServer ([0-9.]+)", string:banner);
if(mysvrVer[1] != NULL)
{
  # MyServer Version 0.8.11 and prior
  if(version_is_less_equal(version:mysvrVer[1], test_version:"0.8.11")){
    security_warning(port);
  }
}
