###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_navicopa_server_detect.nasl 6539 2010-01-05 14:00:08Z jan $
#
# NaviCOPA Server Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801100);
  script_version("$Revision: 6354 $: 1.0");
  script_name("NaviCOPA Server Version Detection");
  desc = "
  Overview : This script detects the version of installed NaviCOPA Server
  and saves the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_summary("Set the version of NaviCOPA Server");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www",80);
  exit(0);
}


include("http_func.inc");

httpPort = get_kb_item("Services/www");
if(!httpPort){
  httpPort = 80;
}

if(!get_port_state(httpPort)){
  exit(0);
}

banner = get_http_banner(port:httpPort);
if("NaviCOPA"  >< banner)
{
  ncpaVer = eregmatch(pattern:"Version ([0-9.]+)", string:banner);
  if(!isnull(ncpaVer[1])){
    set_kb_item(name:"NaviCOPA/" + httpPort + "/Ver", value:ncpaVer[1]);
  }
}
