###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_netpbm_xpmtoppm_bof_vuln.nasl 7277 2010-02-16 12:33:29 feb $
#
# NetPBM 'xpmtoppm' Converter Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800471);
  script_version("$Revision: 6755 $: 1.0");
  script_cve_id("CVE-2009-4274");
  script_bugtraq_id(38164);
  script_name("NetPBM 'xpmtoppm' Converter Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is installed with NetPBM and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  The flaw is due a buffer overflow error in the 'converter/ppm/xpmtoppm.c'
  converter when processing malformed header fields of 'X PixMap' (XPM) image
  files.

  Impact:
  Successful exploitation allows attackers to crash an affected application or
  execute arbitrary code by tricking a user into converting a malicious image.

  Impact Level: Application.

  Affected Software/OS:
  NetPBM versions prior to 10.47.07

  Fix:Apply the patch or upgrade to NetPBM 10.47.07
  For Updates Refer, http://sourceforge.net/projects/netpbm/files/
  http://netpbm.svn.sourceforge.net/viewvc/netpbm/stable/converter/ppm/xpmtoppm.c?view=patch&r1=995&r2=1076&pathrev=1076

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://xforce.iss.net/xforce/xfdb/56207
  http://www.vupen.com/english/advisories/2010/0358
  https://bugzilla.redhat.com/show_bug.cgi?id=546580

  CVSS Score:
    CVSS Base Score      : 7.5 (AV:N/AC:N/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of NetPBM");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_dependencies("gb_netpbm_detect.nasl");
  script_family("Buffer overflow");
  script_require_keys("NetPBM/Ver");
  exit(0);
}


include("version_func.inc");

netpbmVer = get_kb_item("NetPBM/Ver");
if(netpbmVer)
{
  # NetPBM version 10.47.07(10.47.7)
  if(version_is_less(version:netpbmVer, test_version:"10.47.7")){
    security_hole(0);
  }
}
