###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_netrisk_sec_bypass_vuln.nasl 4475 2009-09-04 15:57:11Z sep $
#
# NetRisk Security Bypass Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800940);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-7155");
  script_bugtraq_id(27150);
  script_name("NetRisk Security Bypass Vulnerability");
  desc = "
  Overview: This host is installed with NetRisk and is prone to security
  bypass vulnerability.

  Vulnerability Insight:
  The vulnerability is caused because the application does not properly
  restrict access to 'admin/change_submit.php'.

  Impact:
  Successful exploitation will allow remote attackers to bypass security
  restrictions and change the password of arbitrary users via direct request.

  Impact Level: Application

  Affected Software/OS:
  NetRisk version 1.9.7 and prior.

  Fix: No solution or patch is available as on 04th September,2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/netrisk/

  References:
  http://xforce.iss.net/xforce/xfdb/39465
  http://www.security-database.com/detail.php?alert=CVE-2008-7155
  http://downloads.securityfocus.com/vulnerabilities/exploits/27150.pl

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of NetRisk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_netrisk_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

netriskPort = get_http_port(default:80);

if(!netriskPort)
{
  exit(0);
}

netriskVer = get_kb_item("www/" + netriskPort + "/NetRisk");
netriskVer = eregmatch(pattern:"^(.+) under (/.*)$", string:netriskVer);

if(netriskVer[1] != NULL)
{
  if(version_is_less_equal(version:netriskVer[1], test_version:"1.9.7")){
    security_hole(netriskPort);
  }
}
