###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openssl_detect_lin.nasl 823 2009-01-08 17:32:24Z jan $
#
# OpenSSL Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800335);
  script_version("Revision: 1.0 ");
  script_name("OpenSSL Version Detection (Linux)");
  desc = "
  Overview : This script finds the installed version of OpenSSL and saves
  in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_bin(prog_name:"openssl",sock:sock);
foreach sslBin (paths)
{
  sslVer = get_bin_version(full_prog_name:chomp(sslBin), sock:sock,
                           version_argv:"version",
                           ver_pattern:"OpenSSL ([0-9.a-z\-]+)");
  if(sslVer[1] != NULL)
  {
    set_kb_item(name:"OpenSSL/Linux/Ver", value:sslVer[1]);
    ssh_close_connection();
    #exit(0);
  }
}
ssh_close_connection();
