###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_cmd_exec_n_xss_vuln_win.nasl 413 2008-10-31 10:13:23Z oct $
#
# Opera Web Browser Command Execution and XSS Vulnerabilities (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800048);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4794", "CVE-2008-4795");
  script_bugtraq_id(31991);
  script_name("Opera Web Browser Command Execution and XSS Vulnerabilities (Win)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Flaws are due to,
  - certain parameters passed to the History Search functionality are not
    properly sanitised before being used.
  - an error exists in the handling of Javascript URLs in the Links panel.

  Impact: Successful remote attack could inject arbitrary HTML and script code,
  launch cross site scripting attacks on user's browser session when malicious
  data is being viewed.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 9.62 on Windows.

  Fix: Upgrade to Opera 9.62
  http://www.opera.com/download/

  References:
  http://www.opera.com/support/search/view/906/
  http://www.opera.com/support/search/view/907/

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:C/I:C/A:N)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less(version:operaVer, test_version:"9.62")){
  security_hole(0);
}
