###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_file_heap_bof_vuln_win.nasl 515 2008-11-21 11:27:05Z nov $
#
# Opera Web Browser Heap Based Buffer Overflow Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800066);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5178");
  script_bugtraq_id(32323);
  script_name("Opera Web Browser Heap Based Buffer Overflow Vulnerability (Win)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to
  buffer overflow vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an error while processing an overly long
  file:// URI.

  Impact: Successful remote attack could allow arbitrary code execution
  by tricking user into opening malicious HTML file.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.62 and prior on Windows.

  Fix: Upgrade to Opera 9.63
  http://www.opera.com/download/

  References:
  http://milw0rm.com/exploits/7135
  http://www.frsirt.com/english/advisories/2008/3183

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less_equal(version:operaVer, test_version:"9.62")){
  security_hole(0);
}
