###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_mult_vuln_nov09_win.nasl 5566 2009-11-02 16:30:26Z nov $
#
# Opera Multiple Vulnerabilities - Nov09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801140);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3831", "CVE-2009-3832");
  script_bugtraq_id(36850);
  script_name("Opera Multiple Vulnerabilities - Nov09 (Win)");
  desc = "
  Overview: This host is installed with Opera Web Browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  - An error when processing domain names can be exploited to cause a memory
    corruption.
  - An error when processing web fonts can be exploited to change the font of
    the address field and display an arbitrary domain name as an address.

  Impact:
  Attacker can exploit this issue to disclose sensitive information, conduct
  spoofing attacks, Denial of Service or compromise a user's system.

  Impact Level: Application

  Affected Software/OS:
  Opera version prior to 10.01 on Windows.

  Fix: Upgrade to Opera version 10.01 or later
  http://www.opera.com/browser/download/

  References:
  http://secunia.com/advisories/37182
  http://www.opera.com/support/kb/view/938/
  http://www.vupen.com/english/advisories/2009/3073
  http://www.opera.com/docs/changelogs/windows/1001

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(operaVer)
{
  # Check for Opera Version < 10.1 (10.01)
  if(version_is_less(version:operaVer, test_version:"10.1")){
    security_hole(0);
  }
}
