###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_xss_vuln_win.nasl 3326 2009-07-08 10:13:23Z jul $
#
# Opera Web Browser 'Refresh' Header XSS Vulnerabilities (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800651);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2351");
  script_bugtraq_id(35571);
  script_name("Opera Web Browser 'Refresh' Header XSS Vulnerabilities (Win)");
  desc = "

  Overview: The host is installed with Opera Web Browser and is prone to
  Cross-Site Scripting Vulnerability.

  Vulnerability Insight:
  Flaw is due to error in Refresh headers in HTTP responses. It does not block
  javascript: URIs, while injecting a Refresh header or specifying the content
  of a Refresh header

  Impact:
  Successful remote attack could execute arbitrary script code in the context
  of the user running the application and to steal cookie-based authentication
  credentials and other sensitive data that may aid in further attacks.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.52 and prior on Windows.

  Fix: No solution or patch is available as on 08th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.opera.com/download/

  References:
  http://www.securityfocus.com/archive/1/archive/1/504718/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:C/I:C/A:N)
    CVSS Temporal Score : 7.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Opera Web Browser");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

operaVer = get_kb_item("Opera/Win/Version");
if(!operaVer){
  exit(0);
}

if(version_is_less_equal(version:operaVer, test_version:"9.52")){
  security_hole(0);
}
