##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_panda_prdts_detect.nasl 6091 2009-12-08 20:10:24Z dec $
#
# Panda Products Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801079);
  script_version("$Revision: 1.0 $");
  script_name("Panda Products Version Detection");
  desc = "
  Overview : This script finds the installed Panda Products and saves the
  version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of Panda Products in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Panda Software")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  avName = registry_get_sz(key:key + item, item:"DisplayName");
  ##  Check for the Internet Security
  if("Panda Internet Security" >< avName)
  {
    pandaVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(pandaVer != NULL){
     set_kb_item(name:"Panda/InternetSecurity/Ver", value:pandaVer);
    }
  }

  ##  Check for the Global Protection
  if("Panda Global Protection" >< avName)
  {
    pandaVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(pandaVer != NULL){
      set_kb_item(name:"Panda/GlobalProtection/Ver", value:pandaVer);
    }
  }

  ##  Check for the Antivirus
  if("Panda Antivirus" >< avName)
  {
    pandaVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(pandaVer != NULL){
      set_kb_item(name:"Panda/Antivirus/Ver", value:pandaVer);
    }
  }
}
