###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pgp_desktop_local_dos_vuln.nasl 1772 2009-04-17 15:15:24 apr $
#
# PGP Desktop Local Denial of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800600);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0681");
  script_bugtraq_id(34490);
  script_name("PGP Desktop Local Denial of Service Vulnerability");
  desc = "

  Overview:
  This host has PGP Desktop is installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  IOCTL handler in 'pgpdisk.sys' and 'pgpwded.sys' files does not adequately
  validate buffer data associated with the Irp object.

  Impact:
  Successful exploitation allows attackers to execute arbitrary code with
  system privileges or to crash the application.

  Impact Level: Application.

  Affected Software/OS:
  PGP Desktop prior to version 9.10 on Windows.

  Fix:
  Upgrade to PGP Desktop 9.10
  http://www.pgp.com/downloads/desktoptrial/desktoptrial2.html

  References:
  http://secunia.com/advisories/33310/
  http://en.securitylab.ru/lab/PT-2009-01
  http://www.securityfocus.com/archive/1/502633

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PGP Desktop");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_pgp_desktop_detect_win.nasl");
  script_require_keys("PGPDesktop/Win/Ver");
  exit(0);
}


include("version_func.inc");

pgpVer = get_kb_item("PGPDesktop/Win/Ver");
if(!pgpVer){
  exit(0);
}

# Check for version < 9.10
if(version_is_less(version:pgpVer, test_version:"9.10.0.500")){
  security_hole(0);
}
