###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_mult_vuln_aug08.nasl 312 2008-10-07 16:43:56Z oct $
#
# Multiple Vulnerabilities in PHP August-08
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800110);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(29009, 27413, 27786);
  script_cve_id("CVE-2008-2050", "CVE-2008-2051", "CVE-2007-4850",
                "CVE-2008-0599", "CVE-2008-0674");
  script_xref(name:"CB-A", value:"08-0118");
  script_name("Multiple Vulnerabilities in PHP August-08");
  desc = "

  Overview: The host is installed with PHP, that is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The flaws are caused by,
  - an unspecified stack overflow error in FastCGI SAPI (fastcgi.c).
  - an error during path translation in cgi_main.c.
  - an error with an unknown impact/attack vectors.
  - an unspecified error within the processing of incomplete multibyte
    characters in escapeshellcmd() API function.
  - error in curl/interface.c in the cURL library(libcurl), which could be
    exploited by attackers to bypass safe_mode security restrictions.
  - an error in PCRE. i.e buffer overflow error when handling a character class
    containing a very large number of characters with codepoints greater than
    255(UTF-8 mode).

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  security restrictions bypass, access to restricted files, denial of service.

  Impact Level: System

  Affected Software/OS:
  PHP version prior to 5.2.6

  Fix:
  Upgrade to PHP version 5.2.6 or above,
  http://www.php.net/downloads.php

  References:
  http://pcre.org/changelog.txt
  http://www.php.net/ChangeLog-5.php
  http://wiki.rpath.com/wiki/Advisories:rPSA-2008-0176
  http://wiki.rpath.com/wiki/Advisories:rPSA-2008-0178
  http://wiki.rpath.com/wiki/Advisories:rPSA-2008-0086

  CVSS Score:
    CVSS Base Score     : 9.0 (AV:N/AC:L/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 7.0
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

phpPort = get_kb_item("Services/www");
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Debian and Gentoo advisories are available. Once local checks
# are written, we can exit from here.

# Match PHP version < = 5.2.5
if(version_is_less_equal(version:phpVer, test_version:"5.2.5")){
  security_hole(phpPort);
}
