###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpbb_38599.nasl 6935 2010-03-09 21:32:06Z mime $
#
# PhpBB 'feed.php' Security Bypass Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100524);
 script_bugtraq_id(38599);
 script_version ("1.0-$Revision: 6935 $");

 script_name("PhpBB 'feed.php' Security Bypass Vulnerability");

desc = "Overview:
PhpBB is prone to a security-bypass vulnerability.

Attackers may exploit the issue to bypass certain security
restrictions, view restricted content, and perform unauthorized
actions.

PhpBB 3.0.7 is vulnerable; other versions may also be affected.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/38599
http://www.phpbb.com/
http://www.phpbb.com/community/viewtopic.php?f=14&t=2014195

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if PhpBB version is 3.0.7");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("phpbb_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpBB")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "3.0.7")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
