###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpgenealogie_detect.nasl 5168 2009-10-07 16:25:36Z oct $
#
# PHPGenealogie Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801007);
  script_version("$Revision: 1.0 $");
  script_name("PHPGenealogie Version Detection");
  desc = "
  Overview: This script detects the installed version of PHPGenealogie and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the version of PHPGenealogie in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

phpgenPort = get_http_port(default:80);
if(!phpgenPort){
  phpgenPort = 80;
}

if(!get_port_state(phpgenPort)){
  exit(0);
}

foreach path (make_list("/geneald", "/genealogie_sql", "/genealogie", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/Index2.php"), port:phpgenPort);
  rcvRes = http_send_recv(port:phpgenPort, data:sndReq);
  if("genealogie" >< rcvRes)
  {
    phpgenVer = eregmatch(pattern:"> ([0-9.]+)",string:rcvRes);
    if(phpgenVer[1] != NULL)
    {
      set_kb_item(name:"www/" + phpgenPort + "/PHPGenealogie",
                  value:phpgenVer[1] + " under " + path);
    }
  }
}
