###############################################################################
# OpenVAS Vulnerability Test
# $Id:gb_phpmyadmin_csrf_mult.nasl 711 2008-12-23 17:30:29Z dec $
#
# phpMyAdmin Multiple CSRF SQL Injection Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800210);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5621", "CVE-2008-5622");
  script_bugtraq_id(32720);
  script_name("phpMyAdmin Multiple CSRF SQL Injection Vulnerabilities");
  desc = "

  Overview: This host is running phpMyAdmin and is prone to multiple
  CSRF Injection vulnerability.

  Vulnerability Insight:
  This flaw is due to failure in sanitizing user-supplied data before being
  used in the SQL queries via a link or IMG tag to tbl_structure.php with a
  modified table parameter.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes in the
  context of the application and can compromise database, modify the data or
  can compromise the whole web application.

  Affected Software/OS:
  phpMyAdmin, phpMyAdmin version 2.11 to 2.11.9.3 and 3.0 to 3.1.0.9.

  Fix:
  Upgrade to version 2.11.9.4 or 3.1.1.0
  http://www.phpmyadmin.net

  References:
  http://www.milw0rm.com/exploits/7382
  http://www.phpmyadmin.net/home_page/security/PMASA-2008-10.php
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg00784.html

  CVSS Score:
    CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of phpMyAdmin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  port = 80;
}

foreach path (make_list("/phpmyadmin/", cgi_dirs()))
{

  sndReq = http_get(item:string(path, "/index.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);

  if(rcvRes == NULL){
    exit(0);
  }

  if("phpMyAdmin" >< rcvRes)
  {
    phpVer = eregmatch(pattern:"phpMyAdmin ([0-9.]+)", string:rcvRes);
    if(phpVer[1] != NULL)
    {
      # Grep for version 2.11 to 2.11.9.3 and 3.0 to 3.1.0.9
      if(version_in_range(version:phpVer[1], test_version:"2.11",
                          test_version2:"2.11.9.3") ||
         version_in_range(version:phpVer[1], test_version:"3.0",
                          test_version2:"3.1.0.9")){
        security_warning(port);
      }
    }
    exit(0);
  }
}
