###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pidgin_mult_vuln_sep09_win.nasl 4420 2009-09-03 13:07:19Z sep $
#
# Pidgin Multiple Vulnerabilities - Sep09 (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800931);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3025", "CVE-2009-3026");
  script_name("Pidgin Multiple Vulnerabilities - Sep09 (Win)");
  desc = "
  Overview:
  This host has Pidgin installed and is prone to multiple vulnerabilities.

  Vulnerability Insight:
 - The application connects to Jabberd servers that are not fully compliant
   with the XMPP specifications without encryption, even if the
   'Require SSL/TLS' setting is configured.
 - An error ocurrs in compililg libpurple while processing malicious links
   received via the Yahoo Messenger protocol.

  Impact:
  Successful exploitation will let the attacker obtain sensitive information
  by sniffing XMPP sessions and cause application crash.

  Impact Level: Application

  Affected Software/OS:
  Pidgin version 2.6.0 on Windows

  Fix: Upgrade to Pidgin version 2.6.1
  http://pidgin.im/download

  References:
  http://secunia.com/advisories/36384/
  http://pidgin.im/news/security/?id=35
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=542891
  http://www.openwall.com/lists/oss-security/2009/08/19/2

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_pidgin_detect_win.nasl");
  script_require_keys("Pidgin/Win/Ver");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

pidginVer = get_kb_item("Pidgin/Win/Ver");

if(pidginVer != NULL)
{
  if(version_is_equal(version:pidginVer, test_version:"2.6.0")){
    security_hole(0);
  }
}
