###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_realplayer_detect_win.nasl 996 2009-02-10 10:45:02Z feb $
#
# RealPlayer Application Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800508);
  script_version("$Revision: 1.0 $");
  script_name("RealPlayer Application Version Detection");
  desc = "
  Overview: This script detects the version of RealPlayer application
  and sets the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of RealPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\RealNetworks\RealPlayer")){
  exit(0);
}

exeFile = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\App Paths\RealPlay.exe",
                          item:"Path");
if(!exeFile){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exeFile);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exeFile +
                            "\realplay.exe");

rpVer = GetVer(share:share, file:file);
if(rpVer != NULL){
  set_kb_item(name:"RealPlayer/Win/Ver", value:rpVer);
}
