##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_robo_ftp_client_detect.nasl 5968 2009-12-01 10:05:35Z nov $
#
# Robo-FTP Client Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801053);
  script_version("$Revision: 1.0 $");
  script_name("Robo-FTP Client Version Detection");
  desc = "
  Overview : This script finds the installed Robo-FTP Client version and saves the
  result in KB item.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set version of Robo-FTP Client in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Robo-FTP")){
  exit(0);
}

path = registry_get_sz(key:"SOFTWARE\Robo-FTP", item:"InstallDir");
if(path != NULL)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file  = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:path +
                                                     "\Robo-FTP.exe");
  ftpVer = GetVer(share:share, file:file);
   if(!isnull(ftpVer)){
    set_kb_item(name:"Robo/FTP/Ver", value:ftpVer);
  }
}
