###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_shibboleth_sp_detect_win.nasl 5096 2009-10-13 12:40:24Z oct $
#
# Shibboleth Service Provider Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801115);
  script_version("$Revision: 1.0 $");
  script_name("Shibboleth Service Provider Version Detection");
  desc = "
  Overview: This script detects the installed version of Shibboleth Service
  Provider and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set version of Shibboleth Service Provider in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Shibboleth")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

foreach item (registry_enum_keys(key:key))
{
  shibName = registry_get_sz(key:key + item, item:"DisplayName");

  if("Shibboleth" >< shibName)
  {
    shibVer = registry_get_sz(key:key + item, item:"DisplayVersion");

    if(!isnull(shibVer)){
      set_kb_item(name:"Shibboleth/SP/Win/Ver", value:shibVer);
    }
  }
}
