###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_shibboleth_sp_null_char_spoofing_vuln_win.nasl 5096 2009-10-13 13:23:17Z oct $
#
# Shibboleth Service Provider NULL Character Spoofing Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801116);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3475");
  script_name("Shibboleth Service Provider NULL Character Spoofing Vulnerability (Win)");
  desc = "
  Overview: The host has Shibboleth Service Provider installed and is prone to
  NULL Character Spoofing vulnerability.

  Vulnerability Insight:
  The flaw exists when using PKIX trust validation. The application does not
  properly handle a '\0' character in the subject or subjectAltName fields
  of a certificate.

  Impact:
  Successful exploitation could allow man-in-the-middle attackers to spoof
  arbitrary SSL servers via a crafted certificate by a legitimate
  Certification Authority.

  Impact Level: Application

  Affected Software/OS:
  Shibboleth Service Provider version 1.3.x before 1.3.3 and 2.x before 2.2.1
  on Windows.

  Fix: Upgrade Shibboleth Service Provider version 1.3.3 or 2.2.1 or later
  http://shibboleth.internet2.edu/downloads.html

  References:
  http://secunia.com/advisories/36861/
  http://shibboleth.internet2.edu/secadv/secadv_20090817.txt

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_category(ACT_GATHER_INFO);
  script_summary("Check for the version of Shibboleth Service Provider");
  script_family("General");
  script_dependencies("gb_shibboleth_sp_detect_win.nasl");
  script_require_keys("Shibboleth/SP/Win/Ver");
  exit(0);
}


include("version_func.inc");

shibVer = get_kb_item("Shibboleth/SP/Win/Ver");
if(!shibVer){
  exit(0);
}

# Check for Shibboleth Service Provider version 1.3.x < 1.3.3 and 2.x < 2.2.1
if(version_in_range(version:shibVer, test_version:"1.3", test_version2:"1.3.2")||
   version_in_range(version:shibVer, test_version:"2.0", test_version2:"2.2.0")){
  security_hole(0);
}
