###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_slysoft_prdts_detect.nasl 962 2009-04-19 16:07:24Z apr $
#
# SlySoft Product(s) Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800391);
  script_version("Revision: 1.0 $");
  script_name("SlySoft Product(s) Version Detection");
  desc = "
  Overview: This script detects the installed version of SlySoft Product(s)
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of SlySoft Product(s)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

function slysoftGetVer(path)
{
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:path);
  file = ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:path);

  soc = open_sock_tcp(port);
  if(!soc){
    exit(0);
  }

  r = smb_session_request(soc:soc, remote:name);
  if(!r){
    close(soc);
    exit(0);
  }

  prot = smb_neg_prot(soc:soc);
  if(!prot){
    close(soc);
    exit(0);
  }

  r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                        prot:prot);
  if(!r){
    close(soc);
    exit(0);
  }

  uid = session_extract_uid(reply:r);
  if(!uid){
    close(soc);
    exit(0);
  }

  r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
  if(!r){
    close(soc);
    exit(0);
  }

  tid = tconx_extract_tid(reply:r);
  if(!tid){
    close(soc);
    exit(0);
  }

  fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
  if(!fid){
    close(soc);
    exit(0);
  }

  slysoftVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
  if(!slysoftVer){
    slysoftVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:332560);
    close(soc);
    if(!slysoftVer){
      return NULL;
    }
  }
  close(soc);
  return slysoftVer;
}

if(!registry_key_exists(key:"SOFTWARE\SlySoft"))
{
  if(!registry_key_exists(key:"SOFTWARE\Elaborate Bytes")){
    exit(0);
  }
}

# Get the Version for AnyDVD
anydvdPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\AnyDVD.exe", item:"Path");
if(anydvdPath)
{
  anydvdVer = slysoftGetVer(path:anydvdPath + "\AnyDVD.exe");
  if(anydvdVer != NULL){
    set_kb_item(name:"AnyDVD/Ver", value:anydvdVer);
  }
}

# Get the Version for CloneDVD
clonedvdPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                   "\App Paths\CloneDVD2.exe", item:"Path");
if(clonedvdPath)
{
  dvdVer = slysoftGetVer(path:clonedvdPath + "\CloneDVD2.exe");
  if(dvdVer != NULL){
    set_kb_item(name:"CloneDVD/Ver", value:dvdVer);
  }
}
else
{
  clonedvdPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                     "\App Paths\CloneDVD.exe", item:"Path");
  dvdVer = slysoftGetVer(path:clonedvdPath + "\CloneDVD.exe");
  if(dvdVer != NULL){
    set_kb_item(name:"CloneDVD/Ver", value:dvdVer);
  }
}

# Get the Version for CloneCD
clonecdPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                  "\App Paths\CloneCD.exe", item:"Path");
if(clonecdPath)
{
  cdVer = slysoftGetVer(path:clonecdPath + "\CloneCD.exe");
  if(cdVer != NULL){
    set_kb_item(name:"CloneCD/Ver", value:cdVer);
  }
}

# Get the Version for Virtual CloneDrive
drivePath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                "\App Paths\VCDPrefs.exe", item:"Path");
if(drivePath)
{
  driveVer = slysoftGetVer(path:drivePath + "\VCDPrefs.exe");
  if(driveVer != NULL){
    set_kb_item(name:"VirtualCloneDrive/Ver", value:driveVer);
  }
}
