###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sopcast_sopcore_activex_ctrl_dos_vuln_win.nasl 752 2009-03-09 10:47:41Z mar $
#
# SopCast SopCore ActiveX Control DoS Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800530);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0811");
  script_bugtraq_id(33920);
  script_name("SopCast SopCore ActiveX Control DoS Vulnerability (Win)");
  desc = "

  Overview: This host is installed with SopCast SopCore ActiveX and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  Remote arbitrary programs can be executed via executable file name in the
  SetExternalPlayer function of the sopocx.ocx file and persuading a victim
  to visit a specially-crafted Web page.

  Impact:
  Attacker may exploit this issue to execute arbitrary script code and may
  crash the browser.

  Impact Level: Application

  Affected Software/OS:
  SopCast sopocx.ocx version 3.0.3.501 on Windows.

  Fix: No solution or patch is available as on 11th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.sopcast.org/

  Workaround:
  Set the killbit for the CLSID {8FEFF364-6A5F-4966-A917-A3AC28411659}
  http://support.microsoft.com/kb/240797

  References:
  http://milw0rm.com/exploits/8143
  http://xforce.iss.net/xforce/xfdb/48955

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of SopCast SopCore ActiveX");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

sopName = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                  "\Uninstall\SopCast", item:"DisplayName");
if("SopCast" >< sopName)
{
  sopPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                "\Uninstall\SopCast", item:"DisplayIcon");
  if(!sopPath){
    exit(0);
  }

  sopPath = sopPath - "SopCast.exe" + "sopocx.ocx";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sopPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:sopPath);
  sopocxVer = GetVer(share:share, file:file);

  # Check for version of sopocx.ocx
  if(sopocxVer != NULL &&
     version_is_equal(version:sopocxVer, test_version:"3.0.3.501"))
  {
    if(is_killbit_set(clsid:"{8FEFF364-6A5F-4966-A917-A3AC28411659}") == 0){
      security_hole(0);
    }
  }
}
