###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_squidguard_mult_bof_vuln.nasl 5533 2009-11-02 15:33:20Z nov $
#
# SquidGuard Multiple Buffer Overflow Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800965);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3826", "CVE-2009-3700");
  script_bugtraq_id(36800);
  script_name("SquidGuard Multiple Buffer Overflow Vulnerabilities");
  desc = "
  Overview: The host is installed with SquidGuard and is prone to multiple
  Buffer Overflow vulnerabilities.

  Vulnerability Insight:
  - A boundary error occurs in 'sgLog.c' while handling overly long URLs with
    multiple '/' characters while operating in the emergency mode.
  - Multiple buffer overflow errors occur in 'sg.h.in' and 'sgDiv.c.in' while
    processing overly long URLs and can be exploited to bypass the URL filter.

  Impact:
  Remote attackers can exploit this issue to bypass the filter security and to
  cause Denail of Service due to application hang.

  Impact Level: System/Application

  Affected Software/OS:
  SquidGuard version 1.3 and 1.4

  Fix: Apply the following patches.
  http://www.squidguard.org/Downloads/Patches/1.4/Readme.Patch-20091019
  http://www.squidguard.org/Downloads/Patches/1.4/Readme.Patch-20091015

  *****
  NOTE: Please ignore this waring if the above mentioned patches are already applied.
  *****

  References:
  http://secunia.com/advisories/37107
  http://xforce.iss.net/xforce/xfdb/53922
  http://www.vupen.com/english/advisories/2009/3013
  http://securitytracker.com/alerts/2009/Oct/1023079.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of SquidGuard");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_squidguard_detect.nasl");
  script_require_keys("SquidGuard/Ver");
  exit(0);
}


include("version_func.inc");

sgVer = get_kb_item("SquidGuard/Ver");
if(!sgVer){
  exit(0);
}

if(version_is_equal(version:sgVer, test_version:"1.4")||
   version_is_equal(version:sgVer, test_version:"1.3")){
  security_warning(0);
}
