###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_jre_mult_vuln_aug09.nasl 3821 2009-08-19 10:43:20Z agu $
#
# Sun Java JDK/JRE Multiple Vulnerabilities - Aug09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800867);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2670", "CVE-2009-2671", "CVE-2009-2672",
                "CVE-2009-2673", "CVE-2009-2675", "CVE-2009-2475",
                "CVE-2009-2689");
  script_bugtraq_id(35939, 35943, 35944);
  script_name("Sun Java JDK/JRE Multiple Vulnerabilities - Aug09");
  desc = "

  Overview: This host is installed with Sun Java JDK/JRE and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Refer to the reference links for more information on the vulnerabilities.

  Impact:
  Successful exploitation could allows remote attacker to gain privileges via
  untrusted applet or Java Web Start application in the context of the affected
  system.

  Impact Level: System/Application

  Affected Software/OS:
  Sun Java JDK/JRE version 6 before Update 15 or 5.0 before Update 20

  Fix: Upgrade to JDK/JRE version 6 Update 15 or 5 Update 20
  http://java.sun.com/javase/downloads/index.jsp
  http://java.sun.com/javase/downloads/index_jdk5.jsp
  or
  Apply the patch from below link,
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-125136-16-1
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-125139-16-1
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-118667-22-1

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/36159
  http://secunia.com/advisories/36162
  http://secunia.com/advisories/36180
  http://secunia.com/advisories/36199
  http://java.sun.com/javase/6/webnotes/6u15.html
  http://java.sun.com/j2se/1.5.0/ReleaseNotes.html
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-263408-1
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-263409-1
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-263488-1

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Sun Java JDK/JRE");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_java_prdts_detect_win.nasl",
                      "gb_java_prdts_detect_lin.nasl");
  script_require_keys("Sun/Java/JRE/Win/Ver", "Sun/Java/JRE/Linux/Ver",
                      "Sun/Java/JDK/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get KB for JDK Version On Windows
jdkVer = get_kb_item("Sun/Java/JDK/Win/Ver");
jdkVer = ereg_replace(pattern:"_", string:jdkVer, replace: ".");

if(jdkVer)
{
  # Check for 1.5 < 1.5.0_20 (5 Update 20) or 1.6 < 1.6.0_15 (6 Update 15)
  if(version_in_range(version:jdkVer, test_version:"1.5", test_version2:"1.5.0.19")||
     version_in_range(version:jdkVer, test_version:"1.6", test_version2:"1.6.0.14"))
  {
    security_hole(0);
    exit(0);
  }
}

# Get KB for JRE Version On Windows
jreVer = get_kb_item("Sun/Java/JRE/Win/Ver");

if(isnull(jreVer))
{
  # Get KB for JRE Version On Linux
  jreVer = get_kb_item("Sun/Java/JRE/Linux/Ver");
  if(isnull(jreVer))
    exit(0);
}

jreVer = ereg_replace(pattern:"_", string:jreVer, replace: ".");
jreVer = ereg_replace(pattern:"-b[0-9][0-9]", string:jreVer, replace:"");
if(jreVer)
{
  # Check for 1.5 < 1.5.0_20 (5 Update 20) or 1.6 < 1.6.0_15 (6 Update 15)
  if(version_in_range(version:jreVer, test_version:"1.5", test_version2:"1.5.0.19")||
     version_in_range(version:jreVer, test_version:"1.6", test_version2:"1.6.0.14")){
    security_hole(0);
  }
}
