##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_sys_web_proxy_server_detect.nasl 3682 2009-08-11 21:17:35Z aug $
#
# Sun Java System Web Proxy Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800864);
  script_version("$Revision: 1.0 $");
  script_name("Sun Java System Web Proxy Server Version Detection");
  desc = "

  Overview : This script detects the installed version of Java System Web Proxy
  Server and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of Java System Web Proxy Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 8081, 8080);
  exit(0);
}


include("http_func.inc");

# Get the Default HTTP Port for Web Proxy Server
sunPort = get_http_port(default:8081);
if(!sunPort){
  sunPort = 8081;
}

# Check for Port State
if(!get_port_state(sunPort)){
  exit(0);
}

# Get for HTTP Banner
banner = get_http_banner(port:sunPort);

if(!isnull(banner))
{
  # Grep for Web Proxy Server Version
  wpsVer = eregmatch(pattern:"Server: Sun-Java-System-Web-Proxy-Server" +
                             "/([0-9.]+)", string:banner);

  # Set KB for Web Proxy Server Version
  if(!isnull(wpsVer))
  {
    set_kb_item(name:"Sun/JavaWebProxyServ/Ver", value:wpsVer[1]);
    set_kb_item(name:"Sun/JavaWebProxyServ/Port", value:sunPort);
  }
}
