###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_synactis_allinthebox_activex_code_exec_vuln.nasl 1012 2009-02-12 11:00:24Z feb $
#
# Synactis All-In-The-Box ActiveX Remote Code Execution Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800245);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0465");
  script_bugtraq_id(33535);
  script_name("Synactis All-In-The-Box ActiveX Remote Code Execution Vulnerability");
  desc = "

  Overview: This host is installed with All-In-The-Box ActiveX and is prone to
  Remote Code Execution Vulnerability.

  Vulnerability Insight:
  This flaw is due to an ActiveX control All_In_The_Box.ocx providing insecure
  SaveDoc method.

  Impact:
  Successful exploitation will let the attacker overwrite arbitrary files on
  the system via a filename terminated by a NULL byte.

  Impact Level: System/Application

  Affected Software/OS:
  Synactis, All-In-The-Box ActiveX version 3.1.2.0 and prior.

  Workaround:
  Set the Killbit for the vulnerable CLSID {B5576893-F948-4E0F-9BE1-A37CB56D66FF}
  http://support.microsoft.com/kb/240797

  Fix: No solution or patch is available as on 13th February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://synactis.com/pdf-in-the-box-downloads.asp

  References:
  http://secunia.com/advisories/33728
  http://www.milw0rm.com/exploits/7928
  http://www.dsecrg.com/pages/vul/show.php?id=62

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.0
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the AITB OCX Version and Killbit");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_activex.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

ocxPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\Uninstall\Synactis_All_In-The-Box_ActiveX",
                          item:"Unregister");
if(!ocxPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:ocxPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:ocxPath);

ocxVer = GetVer(file:file, share:share);
if(!ocxVer){
  exit(0);
}

# Grep for All_In_The_Box.ocx version 3.1.2.0 and prior
if(version_is_less_equal(version:ocxVer, test_version:"3.1.2.0"))
{
  if(is_killbit_set(clsid:"{B5576893-F948-4E0F-9BE1-A37CB56D66FF}") == 0){
    security_hole(0);
  }
}
