###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tikiwiki_38608.nasl 6971 2010-03-15 18:33:39Z mime $
#
# TikiWiki Versions Prior to 4.2 Multiple Unspecified Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100537);
 script_bugtraq_id(38608);
 script_version ("1.0-$Revision: 6971 $");

 script_name("TikiWiki Versions Prior to 4.2 Multiple Unspecified Vulnerabilities");

desc = "Overview:
TikiWiki is prone to multiple unspecified vulnerabilities, including:

- An unspecified SQL-injection vulnerability
- An unspecified authentication-bypass vulnerability
- An unspecified vulnerability

Exploiting these issues could allow an attacker to compromise the
application, access or modify data, exploit latent vulnerabilities in
the underlying database, and gain unauthorized access to the affected
application. Other attacks are also possible.

Versions prior to TikiWiki 4.2 are vulnerable.

Solution:
The vendor has released an advisory and fixes. Please see the
references for details.

References:
http://www.securityfocus.com/bid/38608
http://tikiwiki.svn.sourceforge.net/viewvc/tikiwiki?view=rev&revision=24734
http://tikiwiki.svn.sourceforge.net/viewvc/tikiwiki?view=rev&revision=25046
http://tikiwiki.svn.sourceforge.net/viewvc/tikiwiki?view=rev&revision=25424
http://tikiwiki.svn.sourceforge.net/viewvc/tikiwiki?view=rev&revision=25435
http://info.tikiwiki.org/article86-Tiki-Announces-3-5-and-4-2-Releases
http://info.tikiwiki.org/tiki-index.php?page=homepage

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if TikiWiki version is < 4.2");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_tikiwiki_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/TikiWiki")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_less(version: vers, test_version: "4.2")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
