###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_torrent_trader_classic_mult_vuln.nasl 3077 2009-07-07 16:49:25Z jul $
#
# TorrentTrader Classic Multiple Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800522);
  script_version("Revision: 1.0");
  script_cve_id("CVE-2009-2156", "CVE-2009-2157", "CVE-2009-2158",
                "CVE-2009-2159", "CVE-2009-2160", "CVE-2009-2161");
  script_bugtraq_id(35369);
  script_name("TorrentTrader Classic Multiple Vulnerabilities");
  desc = "

  Overview: This host is running TorrentTrader Classic and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Multiple flaws due to,improper validation of user-supplied input data to
  different parametes and Access to the '.php' scripts are not properly
  restricted.

  Impact:
  Successful exploitation will let the attacker to inject and execute
  arbitrary SQL queries via malicious SQL code, and can gain sensitive
  information about remote system user credentials and database.

  Impact level: Application/System

  Affected Software/OS:
  TorrentTrader Classic version 1.09 and prior.

  Fix:
  No solution or patch is available as on 07th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/torrenttrader

  References:
  http://secunia.com/advisories/35456
  http://www.securityfocus.com/archive/1/archive/1/504294/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for Attack string and TorrentTrader Classic Version");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_torrent_trader_classic_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ttcPort = get_http_port(default:80);
if(!ttcPort){
  exit(0);
}

ttcVer = get_kb_item("www/" + ttcPort + "/TorrentTraderClassic");
ttcVer = eregmatch(pattern:"^(.+) under (/.*)$", string:ttcVer);

if((ttcVer[2] != NULL) && (!safe_checks()))
{
  sndReq = http_get(item:string(ttcVer[2],"/upload/browse.php" +
                           "?wherecatin=waraxe"), port:ttcPort);
  rcvRes = http_send_recv(port:ttcPort, data:sndReq);
  if("Unknown column 'waraxe' in 'where clause'" >< rcvRes)
  {
    security_warning(ttcPort);
    exit(0);
  }
}

if(ttcVer[1] != NULL)
{
  if(version_is_less_equal(version:ttcVer[1], test_version:"1.09")){
    security_warning(ttcPort);
   }
}
