###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox-themes-ubuntu regression USN-398-3
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840032);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "398-3");
  script_cve_id("");
  script_name( "Ubuntu Update for firefox-themes-ubuntu regression USN-398-3");
  desc = "

  Vulnerability Insight:

  USN-398-1 fixed vulnerabilities in Firefox.  Due to the updated version,
  a flaw was uncovered in the Firefox Themes bundle, which erroneously
  reported to be incompatible with the updated Firefox.  This update fixes
  the problem.
  
  We apologize for the inconvenience.

  Affected Software/OS:
  firefox-themes-ubuntu regression on Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000458.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox-themes-ubuntu regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"firefox-themes-ubuntu", ver:"0.5.4.1~6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}