###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libapache2-mod-python vulnerability USN-430-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840039);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "430-1");
  script_cve_id("CVE-2004-2680");
  script_name( "Ubuntu Update for libapache2-mod-python vulnerability USN-430-1");
  desc = "

  Vulnerability Insight:

  Miles Egan discovered that mod_python, when used in output filter mode,
  did not handle output larger than 16384 bytes, and would display freed
  memory, possibly disclosing private data.  Thanks to Jim Garrison of the
  Software Freedom Law Center for identifying the original bug as a
  security vulnerability.

  Affected Software/OS:
  libapache2-mod-python vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000495.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libapache2-mod-python vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libapache2-mod-python2.4", ver:"3.1.4-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapache2-mod-python-doc", ver:"3.1.4-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapache2-mod-python", ver:"3.1.4-0ubuntu1.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"libapache2-mod-python2.3", ver:"3.1.3-3ubuntu1.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapache2-mod-python2.4", ver:"3.1.3-3ubuntu1.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapache2-mod-python-doc", ver:"3.1.3-3ubuntu1.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libapache2-mod-python", ver:"3.1.3-3ubuntu1.1", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}