###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mysql-dfsg-5.0 vulnerability USN-440-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840012);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "440-1");
  script_cve_id("CVE-2007-1420");
  script_name( "Ubuntu Update for mysql-dfsg-5.0 vulnerability USN-440-1");
  desc = "

  Vulnerability Insight:

  Stefan Streichbier and B. Mueller of SEC Consult discovered that MySQL
  subselect queries using &quot;ORDER BY&quot; could be made to crash the MySQL
  server.  An attacker with access to a MySQL instance could cause an
  intermitant denial of service.

  Affected Software/OS:
  mysql-dfsg-5.0 vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000508.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mysql-dfsg-5.0 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0_5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0_5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.22-0ubuntu6.06.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0_5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0_5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.24a-9ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}