###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for evolution-data-server vulnerability USN-475-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840083);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "475-1");
  script_cve_id("CVE-2007-3257");
  script_name( "Ubuntu Update for evolution-data-server vulnerability USN-475-1");
  desc = "

  Vulnerability Insight:

  Philip Van Hoof discovered that the IMAP client in Evolution did not
  correctly verify the SEQUENCE value.  A malicious or spoofed server
  could exploit this to execute arbitrary code with user privileges.

  Affected Software/OS:
  evolution-data-server vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-June/000548.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of evolution-data-server vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"evolution-data-server-dbg", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcamel1.2-10", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcamel1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libebook1.2-9", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libebook1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecal1.2-7", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecal1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-book1.2-2", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-book1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-cal1.2-6", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-cal1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserver1.2-9", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserver1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserverui1.2-8", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserverui1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libegroupwise1.2-13", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libegroupwise1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexchange-storage1.2-3", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexchange-storage1.2-dev", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server-common", ver:"1.10.1-0ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"evolution-data-server-dbg", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcamel1.2-8", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcamel1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libebook1.2-5", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libebook1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecal1.2-3", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecal1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-book1.2-2", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-book1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-cal1.2-1", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-cal1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserver1.2-7", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserver1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserverui1.2-6", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserverui1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libegroupwise1.2-9", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libegroupwise1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexchange-storage1.2-1", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexchange-storage1.2-dev", ver:"1.6.1-0ubuntu7.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"evolution-data-server-dbg", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcamel1.2-8", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcamel1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libebook1.2-9", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libebook1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecal1.2-7", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libecal1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-book1.2-2", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-book1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-cal1.2-6", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedata-cal1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserver1.2-7", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserver1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserverui1.2-8", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libedataserverui1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libegroupwise1.2-12", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libegroupwise1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexchange-storage1.2-2", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexchange-storage1.2-dev", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"evolution-data-server-common", ver:"1.8.1-0ubuntu5.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}