###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-restricted-modules-2.6.15/.17/.20 vulnerabilities USN-479-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840081);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "479-1");
  script_cve_id("CVE-2006-7177", "CVE-2006-7178", "CVE-2006-7179", "CVE-2006-7180", "CVE-2007-2829", "CVE-2007-2830", "CVE-2007-2831");
  script_name( "Ubuntu Update for linux-restricted-modules-2.6.15/.17/.20 vulnerabilities USN-479-1");
  desc = "

  Vulnerability Insight:

  Multiple flaws in the MadWifi driver were discovered that could lead
  to a system crash.  A physically near-by attacker could generate
  specially crafted wireless network traffic and cause a denial of
  service. (CVE-2006-7177, CVE-2006-7178, CVE-2006-7179, CVE-2007-2829,
  CVE-2007-2830)
  
  A flaw was discovered in the MadWifi driver that would allow unencrypted
  network traffic to be sent prior to finishing WPA authentication.
  A physically near-by attacker could capture this, leading to a loss of
  privacy, denial of service, or network spoofing. (CVE-2006-7180)
  
  A flaw was discovered in the MadWifi driver's ioctl handling.  A local
  attacker could read kernel memory, or crash the system, leading to a
  denial of service. (CVE-2007-2831)

  Affected Software/OS:
  linux-restricted-modules-2.6.15/.17/.20 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-June/000552.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of linux-restricted-modules-2.6.15/.17/.20 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.20-16_3.11+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control", ver:"8.34.8+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.34.8+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.20-16-386_2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.20-16-generic_2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.20-16-lowlatency_2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.9631+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7184+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7184+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-new-dev", ver:"1.0.9755+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-new", ver:"1.0.9755+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.9631+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.9631+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7184+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-new-kernel-source", ver:"1.0.9755+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-player-kernel-modules", ver:"2.6.20-16_2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-server-kernel-modules", ver:"2.6.20-16_2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-tools-kernel-modules", ver:"2.6.20-16_2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.1.0-8.34.8+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.1.0-8.34.8+2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.20.5-16.29", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.15-28_3.11+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control", ver:"8.25.18+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.25.18+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.15-28-386_2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.15-28-686_2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.15-28-k7_2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.8776+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7174+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7174+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.8776+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.8776+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7174+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.0.0-8.25.18+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.0.0-8.25.18+2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.15.12-28.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.17-11_3.11+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control", ver:"8.28.8+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source", ver:"8.28.8+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.17-11-386_2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.17-11-generic_2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"1.0.8776+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"1.0.7184+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"1.0.7184+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"1.0.8776+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"1.0.8776+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"1.0.7184+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"vmware-player-kernel-modules", ver:"2.6.17-11_2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.1.0-8.28.8+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.1.0-8.28.8+2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.17.8-11.2", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}