###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for link-grammar vulnerability USN-545-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840147);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "545-1");
  script_cve_id("CVE-2007-5395");
  script_name( "Ubuntu Update for link-grammar vulnerability USN-545-1");
  desc = "

  Vulnerability Insight:

  Alin Rad Pop discovered that AbiWord's Link Grammar parser did not
  correctly handle overly-long words.  If a user were tricked into opening
  a specially crafted document, AbiWord, or other applications using Link
  Grammar, could be made to crash.

  Affected Software/OS:
  link-grammar vulnerability on Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-November/000627.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of link-grammar vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"liblink-grammar4-dev", ver:"4.2.2-4ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"liblink-grammar4", ver:"4.2.2-4ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"link-grammar", ver:"4.2.2-4ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"link-grammar-dictionaries-en", ver:"4.2.2-4ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}