###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for php5 regression USN-549-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840067);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "549-2");
  script_cve_id("CVE-2007-3998", "CVE-2007-4657", "CVE-2007-4658", "CVE-2007-4662", "CVE-2007-3799", "CVE-2007-2872", "CVE-2007-4660", "CVE-2007-4661", "CVE-2007-1285", "CVE-2007-4670", "CVE-2007-5898", "CVE-2007-5899");
  script_name( "Ubuntu Update for php5 regression USN-549-2");
  desc = "

  Vulnerability Insight:

  USN-549-1 fixed vulnerabilities in PHP.  However, some upstream changes
  were incomplete, which caused crashes in certain situations with Ubuntu
  7.10.  This update fixes the problem.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  It was discovered that the wordwrap function did not correctly
  check lengths.  Remote attackers could exploit this to cause
  a crash or monopolize CPU resources, resulting in a denial of
  service. (CVE-2007-3998)
  
  Integer overflows were discovered in the strspn and strcspn functions.
  Attackers could exploit this to read arbitrary areas of memory, possibly
  gaining access to sensitive information. (CVE-2007-4657)
  
  Stanislav Malyshev discovered that money_format function did not correctly
  handle certain tokens.  If a PHP application were tricked into processing
  a bad format string, a remote attacker could execute arbitrary code with
  application privileges. (CVE-2007-4658)
  
  It was discovered that the php_openssl_make_REQ function did not
  correctly check buffer lengths.  A remote attacker could send a
  specially crafted message and execute arbitrary code with application
  privileges. (CVE-2007-4662)
  
  It was discovered that certain characters in session cookies were not
  handled correctly.  A remote attacker could injection values which could
  lead to altered application behavior, potentially gaining additional
  privileges. (CVE-2007-3799)
  
  Gerhard Wagner discovered that the chunk_split function did not
  correctly handle long strings.  A remote attacker could exploit this
  to execute arbitrary code with application privileges.  (CVE-2007-2872,
  CVE-2007-4660, CVE-2007-4661)
  
  Stefan Esser discovered that deeply nested arrays could be made to
  fill stack space.  A remote attacker could exploit this to cause a
  crash or monopolize CPU resources, resulting in a denial of service.
  (CVE-2007-1285, CVE-2007-4670)
  
  Rasmus Lerdorf discovered that the htmlentities and htmlspecialchars
  functions did not correctly stop when handling partial multibyte
  sequences.  A remote attacker could exploit this to read certain areas of
  memory, possibly gaining access to sensitive information. (CVE-2007-5898)
  
  It was discovered that the output_add_rewrite_var fucntion would
  sometimes leak session id information to forms targeting remote URLs.
  Malicious remote sites could use this information to gain access to a
  PHP application user's login credentials. (CVE-2007-5899)

  Affected Software/OS:
  php5 regression on Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-December/000634.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of php5 regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.2.3-1ubuntu6.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}