###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for tetex-bin, texlive-bin vulnerabilities USN-554-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840006);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "554-1");
  script_cve_id("CVE-2007-5935", "CVE-2007-5936", "CVE-2007-5937");
  script_name( "Ubuntu Update for tetex-bin, texlive-bin vulnerabilities USN-554-1");
  desc = "

  Vulnerability Insight:

  Bastien Roucaries discovered that dvips as included in tetex-bin
  and texlive-bin did not properly perform bounds checking. If a
  user or automated system were tricked into processing a specially
  crafted dvi file, dvips could be made to crash and execute code as
  the user invoking the program. (CVE-2007-5935)
  
  Joachim Schrod discovered that the dviljk utilities created
  temporary files in an insecure way. Local users could exploit a
  race condition to create or overwrite files with the privileges of
  the user invoking the program. (CVE-2007-5936)
  
  Joachim Schrod discovered that the dviljk utilities did not
  perform bounds checking in many instances. If a user or automated
  system were tricked into processing a specially crafted dvi file,
  the dviljk utilities could be made to crash and execute code as
  the user invoking the program. (CVE-2007-5937)

  Affected Software/OS:
  tetex-bin, texlive-bin vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-December/000638.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tetex-bin, texlive-bin vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"3.0-27ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkpathsea4", ver:"3.0-27ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tetex-bin", ver:"3.0-27ubuntu1.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libkpathsea4-dev", ver:"3.0-13ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkpathsea4", ver:"3.0-13ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tetex-bin", ver:"3.0-13ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"3.0-17ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkpathsea4", ver:"3.0-17ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tetex-bin", ver:"3.0-17ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkpathsea4", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-base-bin", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-extra-utils", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-font-utils", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-lang-indic", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-metapost", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-music", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-omega", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"texlive-xetex", ver:"2007-12ubuntu3.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}