###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openssl-blacklist update USN-612-11
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840276);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "612-11");
  script_cve_id("");
  script_name( "Ubuntu Update for openssl-blacklist update USN-612-11");
  desc = "

  Vulnerability Insight:

  USN-612-3 addressed a weakness in OpenSSL certificate and key
  generation and introduced openssl-blacklist to aid in detecting
  vulnerable certificates and keys. This update adds RSA-4096
  blacklists to the openssl-blacklist-extra package and adjusts
  openssl-vulnkey to properly handle RSA-4096 and higher moduli.
  
  Original advisory details:
  A weakness has been discovered in the random number generator used
  by OpenSSL on Debian and Ubuntu systems. As a result of this
  weakness, certain encryption keys are much more common than they
  should be, such that an attacker could guess the key through a
  brute-force attack given minimal knowledge of the system. This
  particularly affects the use of encryption keys in OpenSSH, OpenVPN
  and SSL certificates.

  Affected Software/OS:
  openssl-blacklist update on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/000720.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openssl-blacklist update");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"openssl-blacklist-extra", ver:"0.3.3+0.4-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl-blacklist", ver:"0.3.3+0.4-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"openssl-blacklist-extra", ver:"0.3.3+0.4-0ubuntu0.7.04.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl-blacklist", ver:"0.3.3+0.4-0ubuntu0.7.04.2", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"openssl-blacklist-extra", ver:"0.3.3+0.4-0ubuntu0.8.04.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl-blacklist", ver:"0.3.3+0.4-0ubuntu0.8.04.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"openssl-blacklist-extra", ver:"0.3.3+0.4-0ubuntu0.7.10.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl-blacklist", ver:"0.3.3+0.4-0ubuntu0.7.10.2", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}