###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openssl vulnerabilities USN-620-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840205);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "620-1");
  script_cve_id("CVE-2008-0891", "CVE-2008-1672");
  script_name( "Ubuntu Update for openssl vulnerabilities USN-620-1");
  desc = "

  Vulnerability Insight:

  It was discovered that OpenSSL was vulnerable to a double-free
  when using TLS server extensions. A remote attacker could send a
  crafted packet and cause a denial of service via application crash
  in applications linked against OpenSSL. Ubuntu 8.04 LTS does not
  compile TLS server extensions by default. (CVE-2008-0891)
  
  It was discovered that OpenSSL could dereference a NULL pointer.
  If a user or automated system were tricked into connecting to a
  malicious server with particular cipher suites, a remote attacker
  could cause a denial of service via application crash.
  (CVE-2008-1672)

  Affected Software/OS:
  openssl vulnerabilities on Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/000722.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openssl vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libssl-dev", ver:"0.9.8g-4ubuntu3.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8-dbg", ver:"0.9.8g-4ubuntu3.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libssl0.9.8", ver:"0.9.8g-4ubuntu3.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl", ver:"0.9.8g-4ubuntu3.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssl-doc", ver:"0.9.8g-4ubuntu3.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}