###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mozilla-thunderbird, thunderbird vulnerabilities USN-629-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840295);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "629-1");
  script_cve_id("CVE-2008-2785", "CVE-2008-2798", "CVE-2008-2799", "CVE-2008-2802", "CVE-2008-2803", "CVE-2008-2807", "CVE-2008-2809", "CVE-2008-2811", "CVE-2008-0304");
  script_name( "Ubuntu Update for mozilla-thunderbird, thunderbird vulnerabilities USN-629-1");
  desc = "

  Vulnerability Insight:

  Various flaws were discovered in the browser engine. If a user had
  Javascript enabled and were tricked into opening a malicious web
  page, an attacker could cause a denial of service via application
  crash, or possibly execute arbitrary code with the privileges of the
  user invoking the program. (CVE-2008-2798, CVE-2008-2799)
  
  It was discovered that Thunderbird would allow non-privileged XUL
  documents to load chrome scripts from the fastload file if Javascript
  was enabled. This could allow an attacker to execute arbitrary
  Javascript code with chrome privileges. (CVE-2008-2802)
  
  A flaw was discovered in Thunderbird that allowed overwriting trusted
  objects via mozIJSSubScriptLoader.loadSubScript(). If a user had
  Javascript enabled and was tricked into opening a malicious web page,
  an attacker could execute arbitrary code with the privileges of the
  user invoking the program. (CVE-2008-2803)
  
  Daniel Glazman found that an improperly encoded .properties file in
  an add-on can result in uninitialized memory being used. If a user
  were tricked into installing a malicious add-on, Thunderbird may be
  able to see data from other programs. (CVE-2008-2807)
  
  John G. Myers discovered a weakness in the trust model used by
  Thunderbird regarding alternate names on self-signed certificates.
  If a user were tricked into accepting a certificate containing
  alternate name entries, an attacker could impersonate another
  server. (CVE-2008-2809)
  
  A vulnerability was discovered in the block reflow code of
  Thunderbird. If a user enabled Javascript, this vulnerability could
  be used by an attacker to cause a denial of service via application
  crash, or execute arbitrary code with the privileges of the user
  invoking the program. (CVE-2008-2811)
  
  A flaw was discovered in the browser engine. A variable could be made
  to overflow causing Thunderbird to crash. If a user enable Javascript
  and was tricked into opening a malicious web page, an attacker could
  cause a denial of service or possibly execute arbitrary code with the
  privileges of the user invoking the program. (CVE-2008-2785)
  
  Mozilla developers audited the MIME handling code looking for similar
  vulnerabilities to the previously fixed CVE-2008-0304, and changed
  several function calls to use safer versions of string routines.

  Affected Software/OS:
  mozilla-thunderbird, thunderbird vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-July/000732.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mozilla-thunderbird, thunderbird vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.13+1.5.0.15~prepatch080614d-0ubuntu0.7.04.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.16+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.16+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.16+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.16+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.16+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.16+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.16+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.16+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.16+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.16+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}