###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox vulnerabilities USN-645-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840203);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "645-2");
  script_cve_id("CVE-2008-0016", "CVE-2008-3835", "CVE-2008-3836", "CVE-2008-3837", "CVE-2008-4058", "CVE-2008-4059", "CVE-2008-4060", "CVE-2008-4061", "CVE-2008-4062", "CVE-2008-4063", "CVE-2008-4064", "CVE-2008-4065", "CVE-2008-4066", "CVE-2008-4067", "CVE-2008-4068", "CVE-2008-4069");
  script_name( "Ubuntu Update for firefox vulnerabilities USN-645-2");
  desc = "

  Vulnerability Insight:

  USN-645-1 fixed vulnerabilities in Firefox and xulrunner for Ubuntu
  7.04, 7.10 and 8.04 LTS. This provides the corresponding update for
  Ubuntu 6.06 LTS.
  
  Original advisory details:
  
  Justin Schuh, Tom Cross and Peter Williams discovered errors in the
  Firefox URL parsing routines. If a user were tricked into opening a
  crafted hyperlink, an attacker could overflow a stack buffer and
  execute arbitrary code. (CVE-2008-0016)
  
  It was discovered that the same-origin check in Firefox could be
  bypassed. If a user were tricked into opening a malicious website,
  an attacker may be able to execute JavaScript in the context of a
  different website. (CVE-2008-3835)
  
  Several problems were discovered in the JavaScript engine. This
  could allow an attacker to execute scripts from page content with
  chrome privileges. (CVE-2008-3836)
  
  Paul Nickerson discovered Firefox did not properly process mouse
  click events. If a user were tricked into opening a malicious web
  page, an attacker could move the content window, which could
  potentially be used to force a user to perform unintended drag and
  drop operations. (CVE-2008-3837)
  
  Several problems were discovered in the browser engine. This could
  allow an attacker to execute code with chrome privileges.
  (CVE-2008-4058, CVE-2008-4059, CVE-2008-4060)
  
  Drew Yao, David Maciejak and other Mozilla developers found several
  problems in the browser engine of Firefox. If a user were tricked
  into opening a malicious web page, an attacker could cause a denial
  of service or possibly execute arbitrary code with the privileges
  of the user invoking the program. (CVE-2008-4061, CVE-2008-4062,
  CVE-2008-4063, CVE-2008-4064)
  
  Dave Reed discovered a flaw in the JavaScript parsing code when
  processing certain BOM characters. An attacker could exploit this
  to bypass script filters and perform cross-site scripting attacks.
  (CVE-2008-4065)
  
  Gareth Heyes discovered a flaw in the HTML parser of Firefox. If a
  user were tricked into opening a malicious web page, an attacker
  could bypass script filtering and perform cross-site scripting
  attacks. (CVE-2008-4066)
  
  Boris Zbarsky and Georgi Guninski independently discovered flaws in
  the resource: protocol. An attacker could exploit this to perform
  directory traversal, read information about the system, and prompt
  the user to save information in a file. (CVE-2008-4067,
  CVE-2008-4068)
  
  Billy Hoffman discovered a problem in the XBM decoder. If a user were
  tricked into opening a malicious web page or XBM file, an attacker
  may be able to cause a denial of service via application crash.
  (CVE-2008-4069)

  Affected Software/OS:
  firefox vulnerabilities on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-September/000752.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080614e-0ubuntu3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}