###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-ubuntu-modules-2.6.22/24 vulnerability USN-662-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840257);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "662-2");
  script_cve_id("CVE-2008-4395");
  script_name( "Ubuntu Update for linux-ubuntu-modules-2.6.22/24 vulnerability USN-662-2");
  desc = "

  Vulnerability Insight:

  USN-662-1 fixed vulnerabilities in ndiswrapper in Ubuntu 8.10.
  This update provides the corresponding updates for Ubuntu 8.04 and 7.10.
  
  Original advisory details:
  
  Anders Kaseorg discovered that ndiswrapper did not correctly handle long
  ESSIDs.  For a system using ndiswrapper, a physically near-by attacker
  could generate specially crafted wireless network traffic and execute
  arbitrary code with root privileges. (CVE-2008-4395)

  Affected Software/OS:
  linux-ubuntu-modules-2.6.22/24 vulnerability on Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000774.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of linux-ubuntu-modules-2.6.22/24 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-386_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-generic_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-openvz_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-rt_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-server_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-virtual_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-21-xen_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-386_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-generic_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-server_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-virtual_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-openvz_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-rt_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-21-xen_2.6.24-21.33", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-386_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-generic_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-server_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-virtual_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-rt_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-ume_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.22-15-xen_2.6.22-15.40", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}