###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mozilla-thunderbird, thunderbird vulnerabilities USN-668-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840253);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "668-1");
  script_cve_id("CVE-2008-5012", "CVE-2008-5014", "CVE-2008-5016", "CVE-2008-5017", "CVE-2008-5018", "CVE-2008-5021", "CVE-2008-5022", "CVE-2008-5024");
  script_name( "Ubuntu Update for mozilla-thunderbird, thunderbird vulnerabilities USN-668-1");
  desc = "

  Vulnerability Insight:

  Georgi Guninski, Michal Zalewsk and Chris Evans discovered that the same-origin
  check in Thunderbird could be bypassed. If a user were tricked into opening a
  malicious website, an attacker could obtain private information from data
  stored in the images, or discover information about software on the user's
  computer. (CVE-2008-5012)
  
  Jesse Ruderman discovered that Thunderbird did not properly guard locks on
  non-native objects. If a user had JavaScript enabled and were tricked into
  opening malicious web content, an attacker could cause a browser crash and
  possibly execute arbitrary code with user privileges. (CVE-2008-5014)
  
  Several problems were discovered in the browser, layout and JavaScript engines.
  If a user had JavaScript enabled, these problems could allow an attacker to
  crash Thunderbird and possibly execute arbitrary code with user privileges.
  (CVE-2008-5016, CVE-2008-5017, CVE-2008-5018)
  
  A flaw was discovered in Thunderbird's DOM constructing code. If a user were
  tricked into opening a malicious website while having JavaScript enabled, an
  attacker could cause the browser to crash and potentially execute arbitrary
  code with user privileges. (CVE-2008-5021)
  
  It was discovered that the same-origin check in Thunderbird could be bypassed.
  If a user had JavaScript enabled and were tricked into opening malicious web
  content, an attacker could execute JavaScript in the context of a different
  website. (CVE-2008-5022)
  
  Chris Evans discovered that Thunderbird did not properly parse E4X documents,
  leading to quote characters in the namespace not being properly escaped.
  (CVE-2008-5024)
  
  Boris Zbarsky discovered that Thunderbird did not properly process comments in
  forwarded in-line messages. If a user had JavaScript enabled and opened a
  malicious email, an attacker may be able to obtain information about the
  recipient.

  Affected Software/OS:
  mozilla-thunderbird, thunderbird vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000788.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mozilla-thunderbird, thunderbird vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"1.5.0.13+1.5.0.15~prepatch080614h-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-inspector", ver:"1.5.0.13+1.5.0.15~prepatch080614h-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-typeaheadfind", ver:"1.5.0.13+1.5.0.15~prepatch080614h-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"1.5.0.13+1.5.0.15~prepatch080614h-0ubuntu0.6.06.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.18+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.18+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.18+nobinonly-0ubuntu0.8.10.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.18+nobinonly-0ubuntu0.8.04.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"thunderbird-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird-gnome-support", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"thunderbird", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird-dev", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-thunderbird", ver:"2.0.0.18+nobinonly-0ubuntu0.7.10.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}