###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for clamav vulnerability USN-672-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840213);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "672-1");
  script_cve_id("CVE-2008-5050");
  script_name( "Ubuntu Update for clamav vulnerability USN-672-1");
  desc = "

  Vulnerability Insight:

  Moritz Jodeit discovered that ClamAV did not correctly handle certain
  strings when examining a VBA project.  If a remote attacker tricked ClamAV
  into processing a malicious VBA file, ClamAV would crash, leading to a
  denial of service.

  Affected Software/OS:
  clamav vulnerability on Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000780.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of clamav vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"clamav-daemon", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav-dbg", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav-freshclam", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libclamav-dev", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libclamav5", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav-milter", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav-base", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav-docs", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"clamav-testfiles", ver:"0.94.dfsg.1-1ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}