###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libxml2 vulnerabilities USN-673-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840301);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "673-1");
  script_cve_id("CVE-2008-4225", "CVE-2008-4226");
  script_name( "Ubuntu Update for libxml2 vulnerabilities USN-673-1");
  desc = "

  Vulnerability Insight:

  Drew Yao discovered that libxml2 did not correctly handle certain corrupt
  XML documents.  If a user or automated system were tricked into processing
  a malicious XML document, a remote attacker could cause applications
  linked against libxml2 to enter an infinite loop, leading to a denial
  of service. (CVE-2008-4225)
  
  Drew Yao discovered that libxml2 did not correctly handle large memory
  allocations.  If a user or automated system were tricked into processing a
  very large XML document, a remote attacker could cause applications linked
  against libxml2 to crash, leading to a denial of service. (CVE-2008-4226)

  Affected Software/OS:
  libxml2 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000781.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libxml2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-libxml2", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.24.dfsg-1ubuntu1.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.32.dfsg-4ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.31.dfsg-2ubuntu1.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.30.dfsg-2ubuntu1.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}